--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()												returns time of day in seconds
--Return.Day()												returns day of month
--Return.Month()											returns month as number
--Return.Year()												returns year as number
--Return.Mission()											returns campaign mission number
--Return.CampFlag(flag-n)									returns value of campaign flag
--Return.AirUnitActive("UnitName")							returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")							returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")							returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")							returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")							returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")							returns percentage of alive sub elements in target
--Return.UnitDead(unitname)									(ADD) return vehicle/ship units dead (ADD)
--Return.GroupHidden("GroupName")							returns group hidden status
--Return.GroupProbability("GroupName")						returns group spawn probability value between 0 and 1
--Return.ShipGroupInPoly(GroupName, PolyZonesTable)			(ADD) return boolean whether ship group is in polygon (ADD)

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.TextPlayMission(arg)																--add trigger text to briefing text of this mission only if it is playable
--Action.SetCampFlag(flag-n, boolean/number)												--
--Action.AddCampFlag(flag-n, number)														--
--Action.AddImage("filname.jpg")															--
--Action.CampaignEnd("win"/"draw"/"loss")													--
--Action.TargetActive("TargetName", boolean)												--
--Action.AirUnitActive("UnitName", boolean)													--
--Action.AirUnitBase("UnitName", "BaseName")												--
--Action.AirUnitPlayer("UnitName", boolean)													--
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)				--
--Action.AirUnitRepair()																	--
--Action.GroundUnitRepair()																	-- (ADD) M19.f : Repair Ground
--Action.AddGroundTargetIntel("sideName")													--
--Action.GroupHidden("GroupName", boolean)													--
--Action.GroupProbability("GroupName", number 0-1)											--
--Action.GroupMove(GroupName, ZoneName)														-- (ADD) move vehicle group to refpoint (See the DC_CheckTriggers.lua file for more explanation)
--Action.GroupSlave(GroupName, master, bearing, distance)									-- (ADD)
--Action.ShipMission(GroupName, WPtable, CruiseSpeed, PatrolSpeed, StartTime)				-- (ADD) assign and run a movement mission to a ship group (See the DC_CheckTriggers.lua file for more explanation)
--Action.TemplateActive(TabFile)															-- (ADD) M40 : Template Active GroundGroup moving front (single file : active template) (if tab file: random activation)



--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			[1] = 'Action.Text("Glorious Iran forces attacked Oman and began invasion of the north peninsula. Our final objective is to seize all the penisula invading UEA taking advantage of the surprise and the relatively weak forces at the moment.")',
			[2] = 'Action.Text("Les glorieuses forces armées Iraniennes ont attaqué Oman et l invasion de la presqu île a commencé. Notre objectif final est l invasion de toute la presqu ile en profitant de la surprise et des forces relativement faibles pour l instant.")',
			[3] = 'Action.Text("The US has not yet been able to project all its forces into the UAE and the US Air Force has only half a squadron of A-10C IIs, AWACS and tankers. The US Navy, however, has two CVNs with 2 squadrons of Tomcats and two of Hornets. The UAE has Mirage and Falcon.France has sent a modest force of combat helicopters with Gazelles.")',
			[4] = 'Action.Text("Les USA nont pas encore pu projeter toutes leurs forces aux EAU et US Air Force ne dispose que d un demi escadron de A-10C II, d AWACS et de ravitailleurs. L US Navy dispose cependant de deux CVN avec 2 escadrons de Tomcats et deux de Hornets. Les EAU disposent de Mirage et de Falcon.La France a envoyé une modeste force d hélicoptères de combat avec des Gazelles.")',
			[5] = 'Action.Text("IRIAF have a few Tomcat, F-4, F-5E and a squadron of Mig-29. SU-24s will be our major asset for Air-Ground. Many Air-to-Sol missile sites defend Iranian soil and we have deployed SAM on the beachhead mainly Rapier systems with a lot of Manpads. The main objective of the our forces will be to first acquire air superiority and then destroy all land forces in the UAE territory.")',
			[6] = 'Action.Text("l IRIAF dispose encore de quelques Tomcat, de F-4, de F-5E et d un escdaron de Mig-29. Des SU-24 seront notre atout majeur pour le Air-Sol. De nombreux sites de missiles Air-Sol défendent le sol Iranien et nous avons commencé à en déployer sur la tête de pont avec principalemnt des systèmes Rapier et beaucoup de Manpad. Notre objectif principal sera pour commencer d acquérir la supériorité aérienne puis de détruire toutes les forces terrestres sur le territoire des EAU.")',
			[7] = 'Action.AddImage("Newspaper_FirstNight_blue.jpg", "blue")',
			[8] = 'Action.AddImage("Newspaper_FirstNight_red.jpg", "red")',
		},
	},
	
	
	----- CAMPAIGN END -----
	["Campaign End Victory 1"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 40',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("IRIAF forces inflicted enormous losses on UAE troops and all targets were met. We will be able to invade all UAE s territory. Good game")',
			[3] = 'Action.Text("L IRIAF a infligé des pertes énormes aux troupes des EAU et tous les objectifs ont été atteints. Nous allons pouvoir envahir tout le territoire des EAU. Bien joué")',
			[4] = 'Action.AddImage("Newspaper_Victory_red.jpg", "red")',
			[5] = 'Action.AddImage("Newspaper_Defeat_blue.jpg", "blue")',
			[6] = 'NoMoreNewspaper = true',
		},
	},
	-- ["Campaign End Victory 2"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitReady("81 TFS") + Return.AirUnitReady("23 TFS") + Return.AirUnitReady("91 TFS") + Return.AirUnitReady("41 TFS") + Return.AirUnitReady("72 TFS") + Return.AirUnitReady("51 TFS") + Return.AirUnitReady("21 TFS") + Return.AirUnitReady("83 TFS") + Return.AirUnitReady("21-2 TFS") + Return.AirUnitReady("21-3 TFS") + Return.AirUnitReady("21-4 TFS") < 2',
		-- action = {
			-- [1] = 'Action.CampaignEnd("win")',
			-- [2] = 'Action.Text("The Islamic Republic Iranian Air Force is in ruins. After repeated air strikes and disastrous losses in air-air combat, the Iranians are no longer able to produce any sorties or offer any resistance. The US now owns complete air superiority. With the disappearance of the air threat. Once again the victorious Eagle has proved to be to leading fighter in the world. Well done.")',
			-- [3] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			-- [4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			-- [5] = 'NoMoreNewspaper = true',
		-- },
	-- },
	["Campaign End Loss"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("81 TFS") + Return.AirUnitReady("82 TFS") < 2',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("Ongoing combat operations have exhausted 81 TFS. Loss rate has reached a level where reinforcements are no longer able to sustain combat operations. With the failure of IRIAF to attain air superiority, Central Command has decided to call of the air campaign against UAE. Without destroying UAE forces it seems unlikely that the we will be able to win this war.")',
			[3] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			[4] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			[5] = 'NoMoreNewspaper = true',
		},
	},
	-- ["Campaign End Loss 2"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.TargetAlive("CVN-74 John C. Stennis") == 0',
		-- action = {
			-- [1] = 'Action.CampaignEnd("loss")',
			-- [2] = 'Action.Text("After the CVN-74 John C. Stennis has been hit by air strikes and sunk, VFA-131 is no longer able to fly. Most of its planes are deep into the Caucasian waters and it will need a long time to restore this unit s capabilities. Other US units will have to continue the fight without the VFA-131 support. This is a bitter failure for the Navy")',
			-- [3] = 'Action.AddImage("Newspaper_Defeat.jpg")',
			-- [4] = 'NoMoreNewspaper = true',
		-- },
	-- },
	["Campaign End Loss 3"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["blue"].percent < 30',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("US forces inflicted enormous losses on Iranian troops and all targets were met. Our troops will have to leave Oman to avoid more casualties.")',
			[3] = 'Action.Text("Les forces US ont infligé des pertes énormes à nos troupes. Nous allons devoir quitter Oman pour éviter plus de pertes.")',
			[4] = 'Action.AddImage("Newspaper_Victory_blue.jpg", "blue")',
			[5] = 'Action.AddImage("Newspaper_Defeat_red.jpg", "red")',
			[6] = 'NoMoreNewspaper = true',
		},
	},
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 40',
		action = {
			[1] = 'Action.CampaignEnd("draw")',
			[2] = 'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Islamic Republic Iranian Air Force and infrastructure, US Central Command has called off all squadrons from offensive operations. We hope negociations with Iranian will convince them to stop fortifications in the Persian Gulf")',
			[3] = 'NoMoreNewspaper = true',
		},
	},

----- CAMPAIGN SITUATION -----
	["Campaign first destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 100',
		action = {
			[1] = 'Action.Text("First targets have been destroyed. Keep up the good work")',
			[2] = 'Action.Text("Les premières cibles ont été détruites. Continuez votre bon travail")',
		},
	},
	["Campaign 20 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 80',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
			[2] = 'Action.Text("Les cibles ennemies ont subi des dommages moyens. Continuez votre bon travail")',
		},
	},
	["Campaign 40 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 60',
		action = {
			[1] = 'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
			[2] = 'Action.Text("Les cibles ennemies ont subi de gros dégâts. Les attaques au sol sont vraiment efficaces et nous gagnerons bientôt cette guerre")',
		},
	},
	["Campaign 50 percents destructions"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 50',
		action = {
			[1] = 'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
			[2] = 'Action.Text("Plus de la moitié de nos cibles sont neutralisées. Les renseignements pensent que l ennemi demandera bientôt un cessez-le-feu")',
		},
	},

	----- AIRBASE STRIKES -----
	-- ["Lar Airbase Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Lar Airbase") + Return.TargetAlive("Lar Airbase Strategics") == 0',
		-- action = {
			-- [1] = 'db_airbases["Lar Airbase"].inactive = true',
			-- [2] = 'Action.Text("After the facilities at Lar Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		-- }
	-- },
	["Abu Musa Island Airport Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Abu Musa Island Airport") < 2 and Return.TargetAlive("Abu Musa Island Airport Strategics") < 4',
		action = {
			[1] = 'db_airbases["Abu Musa Island Airport"].inactive = true',
			[2] = 'Action.Text("After the facilities at Abu Musa Island Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		}
	},	
	["Khasab Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Khasab Airbase") < 4 and Return.TargetAlive("Khasab Airbase Strategics") < 4',
		action = {
			[1] = 'db_airbases["Khasab"].inactive = true',
			[2] = 'Action.Text("After the facilities at Khasab Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',
			[3] = 'Action.Text("Après que les installations de l aéroport de Khasab aient été touchées par des frappes aériennes, les opérations aériennes de cette base se sont complètement arrêtées. Le renseignement estime qu en raison des lourds dommages infligés, la base n est plus en mesure de produire des sorties aériennes.")',	
		}
	},
	["Bandar e Jask airfield Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Bandar e Jask airfield") < 3 and Return.TargetAlive("Bandar e Jask airfield Strategics") < 3',
		action = {
			[1] = 'db_airbases["Bandar e Jask airfield"].inactive = true',
			[2] = 'Action.Text("Après que les installations de l aéroport de Bandar e Jask airfield have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',
			[3] = 'Action.Text("After the facilities at Bandar e Jask aient été touchées par des frappes aériennes, les opérations aériennes de cette base se sont complètement arrêtées. Le renseignement estime qu en raison des lourds dommages infligés, la base n est plus en mesure de produire des sorties aériennes.")',	
		}
	},
	-- ["Havadarya Airport Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Havadarya") + Return.TargetAlive("Havadarya Airport Strategics") == 0',
		-- action = {
			-- [1] = 'db_airbases["Havadarya"].inactive = true',
			-- [2] = 'Action.Text("After the facilities at Havadarya Airport have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',			
		-- }
	-- },	
	-- ["Qeshm Island Disabled"] = {
		-- active = true,
		-- condition = 'Return.TargetAlive("Qeshm Island") == 0',
		-- action = {
			-- [1] = 'db_airbases["Qeshm Island"].inactive = true',
		-- }
	-- },	
	-- ["Bandar Abbas Intl Disabled"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.TargetAlive("Bandar Abbas Intl") + Return.TargetAlive("Bandar Abbas Intl Strategics") == 0',
		-- action = {
			-- [1] = 'db_airbases["Bandar Abbas Intl"].inactive = true',
			-- [2] = 'Action.Text("After the facilities at Bandar Abbas Intl have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer able to produce any aviation sorties.")',
		-- [2] = 'Action.AddImage("BDA_Beatty.jpg")',  ---A changer
		-- }
	-- },
	["CVN-74 John C. Stennis sunk"] = {
		active = true,
		condition = 'Return.TargetAlive("CVN-74 John C. Stennis") == 0',
		action = {
			[1] = 'db_airbases["CVN-74 John C. Stennis"].inactive = true',
			[2] = 'Action.Text("After the CVN-74 John C. Stennis has been hit by air strikes and sunk, Squadrons are no longer able to fly. Most of its planes are deep into the Gulf waters and it will need a long time to restore this unit s capabilities")',
			[3] = 'Action.Text("Après que le CVN-74 John C. Stennis ait été touché par des frappes aériennes et coulé, les escadrons ne sont plus en mesure de voler. La plupart de ses avions sont au fond du Golfe et il faudra beaucoup de temps pour restaurer les capacités de cette unité")',	
		}
	},
	["CVN-71 Theodore Roosevelt sunk"] = {
		active = true,
		condition = 'Return.TargetAlive("CVN-71 Theodore Roosevelt") == 0',
		action = {
			[1] = 'db_airbases["CVN-71 Theodore Roosevelt"].inactive = true',
			[2] = 'Action.Text("After the CVN-71 Theodore Roosevelt has been hit by air strikes and sunk, Squadrons are no longer able to fly. Most of its planes are deep into the Gulf waters and it will need a long time to restore this unit s capabilities")',
			[3] = 'Action.Text("Après que le CVN-71 Theodore Roosevelt ait été touché par des frappes aériennes et coulé, les escadrons ne sont plus en mesure de voler. La plupart de ses avions sont au fond du Golfe et il faudra beaucoup de temps pour restaurer les capacités de cette unité")',	
		}
	},	
	["LHA_Tarawa"] = {
		active = true,
		condition = 'Return.TargetAlive("LHA_Tarawa") == 0',
		action = {
			[1] = 'db_airbases["LHA_Tarawa"].inactive = true',
			[2] = 'Action.Text("After the LHA_Tarawa has been hit by air strikes and sunk, VMA 311 is no longer able to fly. Most of its planes are deep into the Gulf waters and it will need a long time to restore this unit s capabilities")',
			[3] = 'Action.Text("Après que le LHA_Tarawa ait été touché par des frappes aériennes et coulé, le VMA 311 n est plus en mesure de voler. La plupart de ses avions sont au fond du Golfe et il faudra beaucoup de temps pour restaurer les capacités de cette unité.")',	
		}
	},
	
	----- RED CAP -----
	["CAP After EWR Destroyed"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("EWR 1") == 0 and Return.TargetAlive("EWR 2") == 0 and Return.TargetAlive("EWR 3") == 0',
		action = {
			[1] = 'Action.TargetActive("Lar Airbase Alert", false)',
			[2] = 'Action.TargetActive("Shiraz Intl Alert", false)',
			[3] = 'Action.TargetActive("Bandar e Jask airfield Alert", false)',
			[4] = 'Action.TargetActive("Qeshm Island Alert", false)',
			[5] = 'Action.TargetActive("Khasab Alert", false)',
			[6] = 'Action.TargetActive("Bandar Abbas Intl 100 Km Alert", false)',
			[7] = 'Action.TargetActive("Bandar e Jask airfield Alert 50", false)',
			[8] = 'Action.Text("With the recent destruction of all Early Warning Radar sites in the operations area, the ability of the enemy to launch interceptors against our strike packages was severely degraded. Intelligence expects that the enemy will increasingly depend on Combat Air Patrols to compensate, though without the support of ground controllers these are estimated to be of limited effectiveness.")',
			[9] = 'Action.Text("Avec la destruction récente de tous les sites de radar d alerte précoce dans la zone d opérations, la capacité de l ennemi à lancer des intercepteurs contre nos paquets de frappe a été gravement dégradée. Le renseignement s attend à ce que l ennemi dépende de plus en plus des CAP pour compenser, bien que sans le soutien des contrôleurs au sol, on estime que leur efficacité est limitée.")',
		},
	},		
	
	----- REPAIR AND REINFORCEMENTS -----
	["GroundUnitRepair"] = {
		active = true,
		condition = 'true',
		action = 'Action.GroundUnitRepair()',
	},
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	["Reinforce VMA 311"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("VMA 331", "VMA 311", 4)',
	},
	["Reinforce 74th FS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("74th FS Res", "74th FS", 4)',
	},	
	["Reinforce 71st FS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("71st FS Res", "71st FS", 12)',
	},
	["Reinforce 2nd Shaheen Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("2nd Shaheen Squadron Res", "2nd Shaheen Squadron", 12)',
	},
	["Reinforce VMFA-312"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/VMFA-312", "VMFA-312", 16)',
	},
	["Reinforce VF-143"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/VF-143", "VF-143", 16)',
	},
	["Reinforce VAW-125"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/VAW-125", "VAW-125", 4)',
	},
	["Reinforce 174 ARW"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/174 ARW", "174 ARW", 6)',
	},
	["Reinforce 175 ARW"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/175 ARW", "175 ARW", 3)',
	},
	["Reinforce 171 ARW"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/171 ARW", "171 ARW", 3)',
	},
	["Reinforce 41 TAS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/41 TAS", "41 TAS", 1)',
	},	
	["Reinforce VFA-106"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/VFA-106", "VFA-106", 16)',
	},
	["Reinforce VF-101"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/VF-101", "VF-101", 16)',
	},
	["Reinforce 4eme RHA"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("3eme RHA", "4eme RHA", 6)',
	},	
	["Reinforce 81 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("82 TFS", "81 TFS", 6)',
	},
	["Reinforce 23 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("11 TFS", "23 TFS", 4)',
	},
	["Reinforce 91 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("31 TFS", "91 TFS", 4)',
	},
	["Reinforce 41 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("141 TFS", "41 TFS", 4)',
	},
	["Reinforce 72 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("73 TFS", "72 TFS", 6)',
	},
	["Reinforce 51 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("52 TFS", "51 TFS", 6)',
	},
--[[	["Reinforce 53 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("54 TFS", "53 TFS", 4)',
	},]]--
	["Reinforce 21 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("22 TFS", "21 TFS", 6)',
	},
	["Reinforce 50 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("50 Squadron Res", "50 Squadron", 6)',
	},
	["Reinforce 51 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("51 Squadron Res", "51 Squadron", 2)',
	},
	["Reinforce 21-3 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("22-3 TFS", "21-3 TFS", 10)',
	},
	["Reinforce 21-4 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("22-4 TFS", "21-4 TFS", 6)',
	},
	["Reinforce 21-2 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("22-2 TFS", "21-2 TFS", 6)',
	},
--[[	["Reinforce 71 TAS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/71 TAS", "71 TAS", 1)',
	},	
	["Reinforce 23 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("24 TFS", "23 TFS", 2)',
	},]]--
	["Reinforce 83 TFS"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("84 TFS", "83 TFS", 4)',
	},
	
----- CARRIER MOVEMENT -----
	["TF-71 No Enter Guldf of Oman"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = {
			[1] = 'Action.ShipMission("TF-71", {"", {"TF-71-2", "TF-71-1", "TF-71-3", "TF-71-4"}}, 10, 8, nil)',
			[2] = 'Action.Text("Intelligence reports that Iranian defenses are still operating near the eastern entrance of the Strait of Hormuz. Until this threat has been eliminated, TF-71 will keep its distance and patrol in the Arabian Sea just outside the Gulf of Oman.")',
			[3] = 'Action.Text("Les services de renseignement rapportent que les défenses iraniennes fonctionnent toujours près de l entrée est du détroit d Ormuz. Tant que cette menace n aura pas été éliminée, le TF-71 gardera ses distances et patrouillera dans la mer d Oman juste à l extérieur du golfe d Oman.")',
		}	
	},
	["TF-74 No Enter Guldf of Oman"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = {
			[1] = 'Action.ShipMission("TF-74", {"", {"TF-74-2", "TF-74-1", "TF-74-3", "TF-74-4"}}, 10, 8, nil)',
			-- [2] = 'Action.Text("Intelligence reports that Iranian defenses are still operating near the eastern entrance of the Strait of Hormuz. Until this threat has been eliminated, TF-74 will keep its distance and patrol in the Arabian Sea just outside the Gulf of Oman.")',
			-- [3] = 'Action.Text("Les services de renseignement rapportent que les défenses iraniennes fonctionnent toujours près de l entrée est du détroit d Ormuz. Tant que cette menace n aura pas été éliminée, TF-74 gardera ses distances et patrouillera dans la mer d Oman juste à l extérieur du golfe d Oman.")',
		}	
	},
	["LHA Group No Enter Guldf of Oman"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = {
			[1] = 'Action.ShipMission("LHA Group", {"", {"LHA-2", "LHA-1", "LHA-3", "LHA-4"}}, 10, 8, nil)',
			-- [2] = 'Action.Text("Intelligence reports that Iranian defenses are still operating near the eastern entrance of the Strait of Hormuz. Until this threat has been eliminated, LHA Group will keep its distance and patrol in the Arabian Sea just outside the Gulf of Oman.")',
			-- [3] = 'Action.Text("Les services de renseignement rapportent que les défenses iraniennes fonctionnent toujours près de l entrée est du détroit d Ormuz. Tant que cette menace n aura pas été éliminée, le groupe LHA gardera ses distances et patrouillera dans la mer d Oman juste à l extérieur du golfe d Oman.")',
		}	
	},
	["TF-71 Patrol Gulf of Oman"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Bandar-E-Jask Silkworm Battery") == 0 and Return.TargetAlive("Iranian suicide speedboat fleet-1") == 0 and Return.TargetAlive("Bandar e Jask airfield") == 0 and Return.TargetAlive("Bandar e Jask airfield Strategics") == 0',
		action = {
			[1] = 'Action.ShipMission("TF-71", {"", {"TF-71-2", "TF-71-4", "TF-71-5", "TF-71-6"}}, 10, 8, nil)',
			[2] = 'Action.Text("After the destruction of the Iranian threats near the eastern entrance of the Strait of Hormuz, TF-71 is allowed to move into and patrol deeper within the Gulf of Oman. This will shorten distance to targets for the Carrier Air Group, allowing less fuel and heavier weapon loads and facilitate striking targets deeper within Iran.")',
			[3] = 'Action.Text("Après la destruction des menaces iraniennes près de l entrée est du détroit d Ormuz, le TF-71 est autorisé à pénétrer et à patrouiller plus profondément dans le golfe d Oman. Cela raccourcira la distance par rapport aux cibles du groupe aéronaval, permettant moins de carburant et des charges d armes plus lourdes et facilitera la frappe de cibles plus profondément en Iran.")',
		}	
	},
	["TF-74 Patrol Gulf of Oman"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Bandar-E-Jask Silkworm Battery") == 0 and Return.TargetAlive("Iranian suicide speedboat fleet-1") == 0 and Return.TargetAlive("Bandar e Jask airfield") == 0 and Return.TargetAlive("Bandar e Jask airfield Strategics") == 0',
		action = {
			[1] = 'Action.ShipMission("TF-74", {"", {"TF-74-2", "TF-74-4", "TF-74-5", "TF-74-6"}}, 10, 8, nil)',
			-- [2] = 'Action.Text("After the destruction of the Iranian threats near the eastern entrance of the Strait of Hormuz, TF-74 is allowed to move into and patrol deeper within the Gulf of Oman. This will shorten distance to targets for the Carrier Air Group, allowing less fuel and heavier weapon loads and facilitate striking targets deeper within Iran.")',
			-- [3] = 'Action.Text("Après la destruction des menaces iraniennes près de l entrée est du détroit d Ormuz, le TF-74 est autorisé à pénétrer et à patrouiller plus profondément dans le golfe d Oman. Cela raccourcira la distance par rapport aux cibles du groupe aéronaval, permettant moins de carburant et des charges d armes plus lourdes et facilitera la frappe de cibles plus profondément en Iran.")',
		}	
	},
	["LHA Group Patrol Gulf of Oman"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Bandar-E-Jask Silkworm Battery") == 0 and Return.TargetAlive("Iranian suicide speedboat fleet-1") == 0 and Return.TargetAlive("Bandar e Jask airfield") == 0 and Return.TargetAlive("Bandar e Jask airfield Strategics") == 0',
		action = {
			[1] = 'Action.ShipMission("LHA Group", {"", {"LHA-2", "LHA-4", "LHA-5", "LHA-6"}}, 10, 8, nil)',
			-- [2] = 'Action.Text("After the destruction of the Iranian threats operating near the eastern entrance of the Strait of Hormuz, LHA Group is allowed to move into and patrol deeper within the Gulf of Oman. This will shorten distance to targets for the Carrier Air Group, allowing less fuel and heavier weapon loads and facilitate striking targets deeper within Iran.")',
			-- [3] = 'Action.Text("Après la destruction des menaces iraniennes opérant près de l entrée est du détroit d Ormuz, le groupe LHA est autorisé à pénétrer et à patrouiller plus profondément dans le golfe d Oman. Cela raccourcira la distance par rapport aux cibles du groupe aéronaval, permettant moins de carburant et des charges d armes plus lourdes et facilitera la frappe de cibles plus profondément en Iran.")',
		}	
	},
	["Iranian suicide speedboat fleet-1 first zone"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() < 4 and Return.TargetAlive("Iranian suicide speedboat fleet-1") > 0',
		action = {
			[1] = 'Action.ShipMission("Iranian suicide speedboat fleet-1", {"", {"Iranian suicide speedboat fleet-1", "Iranian suicide speedboat fleet-2", "Iranian suicide speedboat fleet-3", "Iranian suicide speedboat fleet-4"}}, 12, 8, nil)',
			[2] = 'Action.Text("Intelligence reports that Iranian suicide speed boat are operating south of Bandar E Jask airfield")',
			[3] = 'Action.Text("Les services de renseignement rapportent que des bateaux-suicide iranien opèrent au sud de l aérodrome de Bandar E Jask")',
		}	
	},
	["Iranian suicide speedboat fleet-1 second zone"] = {
		active = true,
		once = false,
		condition = 'Return.Mission() > 3 and Return.TargetAlive("Iranian suicide speedboat fleet-1") > 0',
		action = {
			[1] = 'Action.ShipMission("Iranian suicide speedboat fleet-1", {"", {"Iranian suicide speedboat fleet-5", "Iranian suicide speedboat fleet-6", "Iranian suicide speedboat fleet-7", "Iranian suicide speedboat fleet-8"}}, 12, 8, nil)',
			[2] = 'Action.Text("Intelligence reports that Iranian suicide speed boat are operating near the Fleet")',
			[3] = 'Action.Text("Les services de renseignement rapportent que des bateaux-suicide iranien opèrent près de la TF")',
		}	
	},
	["4th Iranian Transport fleet Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("4th Iranian Transport fleet", {{"4th Iranian Transport fleet-1", "4th Iranian Transport fleet-2", "4th Iranian Transport fleet-3", "4th Iranian Transport fleet-4", "4th Iranian Transport fleet-5", "4th Iranian Transport fleet-6"}}, 8, 5, nil)',
	},
	["1st Iranian Transport fleet Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("1st Iranian Transport fleet", {{"Iran Naval Group -1-1", "Iran Naval Group -1-2", "Iran Naval Group -1-3", "Iran Naval Group -1-4", "Iran Naval Group -1-5", "Iran Naval Group -1-6"}}, 8, 5, nil)',
	},
	["3rd Iranian Transport fleet Sea"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() == 1',
		action = 'Action.ShipMission("3rd Iranian Transport fleet", {{"3rd Iranian Transport fleet-1", "3rd Iranian Transport fleet-2", "3rd Iranian Transport fleet-3", "3rd Iranian Transport fleet-4", "3rd Iranian Transport fleet-5", "3rd Iranian Transport fleet-6", "3rd Iranian Transport fleet-7"}}, 8, 5, nil)',
	},
	
--------------TARGETS LATE ACTIVATIONS	----------------------------
	
	["Scud launcher 1 Activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 4',
		action = {
			[1] = 'Action.TargetActive("Scud 1",true)',
			[2] = 'Action.Text("A Scud launcher has been detected on the coastline far north of Bandar e Jask.")',
			[3] = 'Action.Text("Un lanceur Scud a été détecté le long de la côte loin au nord de Bandar e Jask.")',	
		}
	},
	["Scud launcher 2 Activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 5',
		action = {
			[1] = 'Action.TargetActive("Scud 2",true)',
			[2] = 'Action.Text("A Scud launcher has been detected on Abu Musa Island.")',
			[3] = 'Action.Text("Un lanceur Scud a été détecté sur l île de Abu Musa.")',	
		}
	},
	["Scud launcher 3 Activation"] = {
		active = true,
		once = true,
		condition = 'Return.Mission() > 7',
		action = {
			[1] = 'Action.TargetActive("Scud 3",true)',
			[2] = 'Action.Text("A new Scud launcher has been detected on Abu Musa Island.")',
			[3] = 'Action.Text("Un autre lanceur Scud a été détecté sur l île de Abu Musa.")',	
		}
	},

	----- AVIATION UNIT STATUS -----
	-- ["VFA-131 Alive 75%"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitAlive("VFA-131") + Return.AirUnitReady("R/VFA-131") < 4',
		-- action = 'Action.Text("Aircraft strength of the VFA-131 equiped with Hornet has fallen below 75%.")',
	-- },
	-- ["VFA-131 Alive 50%"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitAlive("VFA-131") + Return.AirUnitReady("R/VFA-131") < 3',
		-- action = 'Action.Text("Aircraft strength of the VFA-131 equiped with Hornet has fallen below 50%. If losses continue at the present rate, the combat capability of the squadron is in jeopardy.")',
	-- },
	-- ["VFA-131 Alive 25%"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitAlive("VFA-131") + Return.AirUnitReady("R/VFA-131") < 2',
		-- action = 'Action.Text("Aircraft strength of the VFA-131 equiped with Hornet has fallen below 25%. The number of available airframes is critically low. The squadron is short of destruction.")',
	-- },
	-- ["Newspaper Nighthawk Down"] = {
		-- active = true,
		-- once = true,
		-- condition = 'Return.AirUnitAlive("417 TFS") < 4',
		-- action = {
			-- [1] = 'Action.AddImage("Newspaper_NighthawkDown.jpg")',
			-- [2] = 'NoMoreNewspaper = true',
		-- },
	-- },
	
	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
	
	

}